﻿using System.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;

//MissionInfoMenu handles the mission info UI
public class MissionInfoMenu : MonoBehaviour
{
    //UI Elements
    public GameObject MissionInfoUI;
    public GameObject GeneratingUI;
    public TimeTrialInfoMenu TimeTrialMenu;
    public CollectionInfoMenu CollectionMenu;
    public WagerRaceInfoMenu WagerRaceMenu;

    public void Start()
    {
        
    }

    /// <summary>
    /// Shows the UI for the corresponding mission
    /// </summary>
    /// <param name="mission">The mission to show info for</param>
    public async void Show(Mission mission)
    {
        //Let's pause the game and show the UI
        GameManager.Instance.SetGameState(Constants.GameState.ShowingMissionInfo);
        Time.timeScale = 0.0f;
        AudioManager.Instance.PauseMusic();
        MissionInfoUI.SetActive(true);

        if(!mission.IsGenerated)
        {
            //Let's generate the mission
            GeneratingUI.SetActive(true);
            await Task.Run(() => mission.Generate());
            GeneratingUI.SetActive(false);
        }

        //All done generating, now show the menu for the type of mission
        GeneratingUI.SetActive(false);

        if(mission.GetType() == typeof(TimeTrialMission))
        {
            TimeTrialMenu.Show((TimeTrialMission)mission);
        }

        else if(mission.GetType() == typeof(CollectionMission))
        {
            CollectionMenu.Show((CollectionMission)mission);
        }

        else if(mission.GetType() == typeof(WagerRaceMission))
        {
            WagerRaceMenu.Show((WagerRaceMission)mission);
        }
    }

    /// <summary>
    /// Hides the UI
    /// </summary>
    public void Hide()
    {
        //Hide both of the UIs
        MissionInfoUI.SetActive(false);
        GeneratingUI.SetActive(false);

        //Now reset the game state and music
        GameManager.Instance.SetGameState(Constants.GameState.Playing);
        Time.timeScale = 1.0f;
        AudioManager.Instance.UnPauseMusic();
    }
}
